function sgr = calculatesgr_ri( z, vshale, throw)
% sgr = calculatesgr_ri( z, vshale, throw)
% 
% Calculates SGR from a vshale log. z is a vector containing the sampling depths, vshale
% is a vector containing the shale content in percent. Throw is a scalar
% value.
% 
% This version of the function expects a log (re)sampled at regular
% intervals (ri).

z = abs(z);

% Interpolate Vshale to a regular 1dm (or df) interval series, this makes
% weighting the data a lot easier.

interval = diff(z);
interval = interval(1);

intervalthrow = ceil( throw / interval );
% zi_is_throw = sum( (zi-zi(1)) <= throw);

z_equals_throw = intervalthrow + 1;

sgr = nan( size(z));

for idx =  z_equals_throw : length(z)
       sgr( idx ) = mean( vshale( idx - intervalthrow : idx));
end
